/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.world.gen.feature.tree;

import com.mojang.serialization.Codec;
import enemeez.simplefarming.config.GenConfig;
import enemeez.simplefarming.init.ModBlocks;
import enemeez.simplefarming.util.WorldGenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FruitTreeFeature
extends Feature<NoFeatureConfig> {
    public static List<BlockState> lookup = new ArrayList<BlockState>();
    public static final BlockState[] LOOKUP = new BlockState[]{ModBlocks.apple_leaves.func_176223_P(), ModBlocks.apricot_leaves.func_176223_P(), ModBlocks.banana_leaves.func_176223_P(), ModBlocks.plum_leaves.func_176223_P(), ModBlocks.orange_leaves.func_176223_P(), ModBlocks.pear_leaves.func_176223_P(), ModBlocks.cherry_leaves.func_176223_P(), ModBlocks.mango_leaves.func_176223_P(), ModBlocks.olive_leaves.func_176223_P()};

    public FruitTreeFeature(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
        this.initList();
    }

    public boolean place(ISeedReader world, ChunkGenerator p_241855_2_, Random random, BlockPos pos, NoFeatureConfig config) {
        boolean flag;
        String id = world.func_201672_e().func_234923_W_().func_240901_a_().toString();
        boolean bl = flag = ((List)GenConfig.blacklist.get()).contains(id) || !((List)GenConfig.whitelist.get()).contains(id);
        if (random.nextInt((Integer)GenConfig.tree_chance.get()) != 0 || flag) {
            return false;
        }
        if (WorldGenHelper.isValidGround(world.func_180495_p(pos.func_177977_b()), (IBlockReader)world, pos) && world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            BlockState leaves = this.getRand();
            FruitTreeFeature.generateTree((IWorld)world, pos, random, leaves);
            return true;
        }
        return false;
    }

    public static void generateTree(IWorld world, BlockPos pos, Random random, BlockState leaves) {
        int x;
        BlockState trunk = ModBlocks.fruit_log.func_176223_P();
        for (int y = 0; y < 4; ++y) {
            if (!world.func_180495_p(pos.func_177981_b(y)).func_185904_a().func_76222_j() && y != 0) continue;
            world.func_180501_a(pos.func_177981_b(y), trunk, 3);
        }
        for (x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (!world.func_180495_p(pos.func_177981_b(3).func_177982_a(x, 0, z)).func_185904_a().func_76222_j()) continue;
                world.func_180501_a(pos.func_177981_b(3).func_177982_a(x, 0, z), leaves, 3);
            }
        }
        for (x = -1; x < 2; ++x) {
            if (x != 0) {
                if (!world.func_180495_p(pos.func_177981_b(2).func_177982_a(x, 0, 0)).func_185904_a().func_76222_j()) continue;
                world.func_180501_a(pos.func_177981_b(2).func_177982_a(x, 0, 0), leaves, 3);
                continue;
            }
            if (world.func_180495_p(pos.func_177981_b(2).func_177982_a(x, 0, 1)).func_185904_a().func_76222_j()) {
                world.func_180501_a(pos.func_177981_b(2).func_177982_a(x, 0, 1), leaves, 3);
            }
            if (!world.func_180495_p(pos.func_177981_b(2).func_177982_a(x, 0, -1)).func_185904_a().func_76222_j()) continue;
            world.func_180501_a(pos.func_177981_b(2).func_177982_a(x, 0, -1), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4)).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4), leaves, 3);
        }
    }

    private void initList() {
        if (((Boolean)GenConfig.apple_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.apple_leaves.func_176223_P());
        }
        if (((Boolean)GenConfig.apricot_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.apricot_leaves.func_176223_P());
        }
        if (((Boolean)GenConfig.banana_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.banana_leaves.func_176223_P());
        }
        if (((Boolean)GenConfig.plum_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.plum_leaves.func_176223_P());
        }
        if (((Boolean)GenConfig.orange_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.orange_leaves.func_176223_P());
        }
        if (((Boolean)GenConfig.pear_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.pear_leaves.func_176223_P());
        }
        if (((Boolean)GenConfig.cherry_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.cherry_leaves.func_176223_P());
        }
        if (((Boolean)GenConfig.mango_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.mango_leaves.func_176223_P());
        }
        if (((Boolean)GenConfig.olive_flag.get()).booleanValue()) {
            lookup.add(ModBlocks.olive_leaves.func_176223_P());
        }
    }

    private BlockState getRand() {
        return lookup.get((int)(Math.random() * (double)lookup.size()));
    }
}

